#!/usr/bin/env python3

# measure wall time: https://en.wiktionary.org/wiki/wall_time

import time, sys, subprocess

def human(seconds):
    if seconds==0:
        return "0s"

    minutes=0
    hours=0
    days=0

    if seconds>=60:
        minutes = seconds // 60
        seconds = seconds - minutes*60

    if minutes>=60:
        hours = minutes // 60
        minutes = minutes - hours*60

    if hours>=24:
        days = hours // 24
        hours = hours - days*24

    rt=""

    if days>0:
        rt=rt+str(days)+"d"
    if hours>0:
        rt=rt+str(hours)+"h"
    if minutes>0:
        rt=rt+str(minutes)+"m"
    if seconds>0:
        rt=rt+str(seconds)+"s"

    return rt

start=time.time()
print (sys.argv[1:])
try:
    subprocess.run(sys.argv[1:])
except KeyboardInterrupt:
    print ("KeyboardInterrupt")

finish=time.time()

print (sys.argv)
print ("seconds: ", int(finish-start))
print ("or: ", human(int(finish-start)))

"""
human(12)
human(60)
human(120)
human(123)
human(60*60+12)
human(86400)
human(86400 + 60*3 + 12)
"""
