
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3, S4, S5, S6, S7, S8, S9,
        S10, S11, S12, S13, S14, S15, S16, S17, S18, S19
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case 'J': state = S1; break;
            case 'F': state = S2; break;
            case 'A': state = S3; break;
            case 'O': state = S4; break;
            case 'S': state = S5; break;
            case 'N': state = S6; break;
            case 'D': state = S7; break;
            case 'M': state = S8; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "J" */
            switch ((unsigned char) *p) {
            case 'u': state = S18; break;
            case 'a': state = S19; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "F" */
            switch ((unsigned char) *p) {
            case 'e': state = S17; break;
            default:  return -1; /* leaf */
            }
            break;

        case S3: /* e.g. "A" */
            switch ((unsigned char) *p) {
            case 'u': state = S15; break;
            case 'p': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S4: /* e.g. "O" */
            switch ((unsigned char) *p) {
            case 'c': state = S14; break;
            default:  return -1; /* leaf */
            }
            break;

        case S5: /* e.g. "S" */
            switch ((unsigned char) *p) {
            case 'e': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S6: /* e.g. "N" */
            switch ((unsigned char) *p) {
            case 'o': state = S12; break;
            default:  return -1; /* leaf */
            }
            break;

        case S7: /* e.g. "D" */
            switch ((unsigned char) *p) {
            case 'e': state = S11; break;
            default:  return -1; /* leaf */
            }
            break;

        case S8: /* e.g. "M" */
            switch ((unsigned char) *p) {
            case 'a': state = S9; break;
            default:  return -1; /* leaf */
            }
            break;

        case S9: /* e.g. "Ma" */
            switch ((unsigned char) *p) {
            case 'r':
            case 'y': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S10: /* e.g. "Dec" */
            return -1; /* leaf */

        case S11: /* e.g. "De" */
            switch ((unsigned char) *p) {
            case 'c': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S12: /* e.g. "No" */
            switch ((unsigned char) *p) {
            case 'v': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S13: /* e.g. "Se" */
            switch ((unsigned char) *p) {
            case 'p': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S14: /* e.g. "Oc" */
            switch ((unsigned char) *p) {
            case 't': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S15: /* e.g. "Au" */
            switch ((unsigned char) *p) {
            case 'g': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S16: /* e.g. "Ap" */
            switch ((unsigned char) *p) {
            case 'r': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S17: /* e.g. "Fe" */
            switch ((unsigned char) *p) {
            case 'b': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S18: /* e.g. "Ju" */
            switch ((unsigned char) *p) {
            case 'l':
            case 'n': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S19: /* e.g. "Ja" */
            switch ((unsigned char) *p) {
            case 'n': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S10: return 0x1; /* "(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)" */
    default: return -1; /* unexpected EOT */
    }
}

