
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3, S4, S5, S6, S7, S8, S9
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case 'm': state = S1; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "m" */
            switch ((unsigned char) *p) {
            case 'i': state = S2; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "mi" */
            switch ((unsigned char) *p) {
            case 's': state = S3; break;
            default:  return -1; /* leaf */
            }
            break;

        case S3: /* e.g. "mis" */
            switch ((unsigned char) *p) {
            case 't': state = S4; break;
            case 's': state = S5; break;
            default:  return -1; /* leaf */
            }
            break;

        case S4: /* e.g. "mist" */
            switch ((unsigned char) *p) {
            case 'r': state = S8; break;
            default:  return -1; /* leaf */
            }
            break;

        case S5: /* e.g. "miss" */
            switch ((unsigned char) *p) {
            case 'u': state = S6; break;
            default:  return -1; /* leaf */
            }
            break;

        case S6: /* e.g. "missu" */
            switch ((unsigned char) *p) {
            case 's': state = S7; break;
            default:  return -1; /* leaf */
            }
            break;

        case S7: /* e.g. "missus" */
            return -1; /* leaf */

        case S8: /* e.g. "mistr" */
            switch ((unsigned char) *p) {
            case 'e': state = S9; break;
            default:  return -1; /* leaf */
            }
            break;

        case S9: /* e.g. "mistre" */
            switch ((unsigned char) *p) {
            case 's': state = S6; break;
            default:  return -1; /* leaf */
            }
            break;

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S5: return 0x1; /* "(miss|missus|mistress)" */
    case S7: return 0x1; /* "(miss|missus|mistress)" */
    default: return -1; /* unexpected EOT */
    }
}

