
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3, S4, S5, S6, S7, S8, S9,
        S10, S11, S12, S13, S14, S15, S16, S17, S18, S19,
        S20, S21, S22, S23, S24, S25, S26, S27, S28, S29,
        S30, S31, S32, S33, S34, S35, S36, S37, S38, S39,
        S40, S41, S42, S43, S44, S45, S46, S47, S48, S49,
        S50, S51, S52, S53, S54
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case '2': state = S1; break;
            case '1': state = S2; break;
            case '0':
            case '3': state = S3; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "2" */
            switch ((unsigned char) *p) {
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S4; break;
            case '0': state = S31; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "1" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8': state = S4; break;
            case '9': state = S31; break;
            default:  return -1; /* leaf */
            }
            break;

        case S3: /* e.g. "0" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S4; break;
            default:  return -1; /* leaf */
            }
            break;

        case S4: /* e.g. "00" */
            switch ((unsigned char) *p) {
            case 'M': state = S5; break;
            case 'D': state = S6; break;
            case 'S': state = S7; break;
            case '-': state = S8; break;
            case 'O': state = S9; break;
            case 'N': state = S10; break;
            case 'A': state = S11; break;
            case 'F': state = S12; break;
            case 'J': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S5: /* e.g. "00M" */
            switch ((unsigned char) *p) {
            case 'a': state = S30; break;
            default:  return -1; /* leaf */
            }
            break;

        case S6: /* e.g. "00D" */
            switch ((unsigned char) *p) {
            case 'e': state = S29; break;
            default:  return -1; /* leaf */
            }
            break;

        case S7: /* e.g. "00S" */
            switch ((unsigned char) *p) {
            case 'e': state = S28; break;
            default:  return -1; /* leaf */
            }
            break;

        case S8: /* e.g. "00-" */
            switch ((unsigned char) *p) {
            case 'M': state = S5; break;
            case 'D': state = S6; break;
            case 'S': state = S7; break;
            case 'O': state = S9; break;
            case 'N': state = S10; break;
            case 'A': state = S11; break;
            case 'F': state = S12; break;
            case 'J': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S9: /* e.g. "00O" */
            switch ((unsigned char) *p) {
            case 'c': state = S27; break;
            default:  return -1; /* leaf */
            }
            break;

        case S10: /* e.g. "00N" */
            switch ((unsigned char) *p) {
            case 'o': state = S26; break;
            default:  return -1; /* leaf */
            }
            break;

        case S11: /* e.g. "00A" */
            switch ((unsigned char) *p) {
            case 'p': state = S24; break;
            case 'u': state = S25; break;
            default:  return -1; /* leaf */
            }
            break;

        case S12: /* e.g. "00F" */
            switch ((unsigned char) *p) {
            case 'e': state = S23; break;
            default:  return -1; /* leaf */
            }
            break;

        case S13: /* e.g. "00J" */
            switch ((unsigned char) *p) {
            case 'u': state = S14; break;
            case 'a': state = S15; break;
            default:  return -1; /* leaf */
            }
            break;

        case S14: /* e.g. "00Ju" */
            switch ((unsigned char) *p) {
            case 'l':
            case 'n': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S15: /* e.g. "00Ja" */
            switch ((unsigned char) *p) {
            case 'n': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S16: /* e.g. "00Dec" */
            switch ((unsigned char) *p) {
            case '2': state = S17; break;
            case '1': state = S18; break;
            case '-': state = S19; break;
            default:  return -1; /* leaf */
            }
            break;

        case S17: /* e.g. "00Dec2" */
            switch ((unsigned char) *p) {
            case '0': state = S20; break;
            default:  return -1; /* leaf */
            }
            break;

        case S18: /* e.g. "00Dec1" */
            switch ((unsigned char) *p) {
            case '9': state = S20; break;
            default:  return -1; /* leaf */
            }
            break;

        case S19: /* e.g. "00Dec-" */
            switch ((unsigned char) *p) {
            case '2': state = S17; break;
            case '1': state = S18; break;
            default:  return -1; /* leaf */
            }
            break;

        case S20: /* e.g. "00Dec20" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S21; break;
            default:  return -1; /* leaf */
            }
            break;

        case S21: /* e.g. "2000Dec0" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S22; break;
            default:  return -1; /* leaf */
            }
            break;

        case S22: /* e.g. "2000Dec00" */
            return -1; /* leaf */

        case S23: /* e.g. "00Fe" */
            switch ((unsigned char) *p) {
            case 'b': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S24: /* e.g. "00Ap" */
            switch ((unsigned char) *p) {
            case 'r': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S25: /* e.g. "00Au" */
            switch ((unsigned char) *p) {
            case 'g': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S26: /* e.g. "00No" */
            switch ((unsigned char) *p) {
            case 'v': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S27: /* e.g. "00Oc" */
            switch ((unsigned char) *p) {
            case 't': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S28: /* e.g. "00Se" */
            switch ((unsigned char) *p) {
            case 'p': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S29: /* e.g. "00De" */
            switch ((unsigned char) *p) {
            case 'c': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S30: /* e.g. "00Ma" */
            switch ((unsigned char) *p) {
            case 'r':
            case 'y': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S31: /* e.g. "20" */
            switch ((unsigned char) *p) {
            case 'M': state = S5; break;
            case 'D': state = S6; break;
            case 'S': state = S7; break;
            case '-': state = S8; break;
            case 'O': state = S9; break;
            case 'N': state = S10; break;
            case 'A': state = S11; break;
            case 'F': state = S12; break;
            case 'J': state = S13; break;
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S32; break;
            default:  return -1; /* leaf */
            }
            break;

        case S32: /* e.g. "200" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S33; break;
            default:  return -1; /* leaf */
            }
            break;

        case S33: /* e.g. "2000" */
            switch ((unsigned char) *p) {
            case 'J': state = S34; break;
            case 'F': state = S35; break;
            case 'A': state = S36; break;
            case '-': state = S37; break;
            case 'O': state = S38; break;
            case 'S': state = S39; break;
            case 'N': state = S40; break;
            case 'D': state = S41; break;
            case 'M': state = S42; break;
            default:  return -1; /* leaf */
            }
            break;

        case S34: /* e.g. "2000J" */
            switch ((unsigned char) *p) {
            case 'u': state = S53; break;
            case 'a': state = S54; break;
            default:  return -1; /* leaf */
            }
            break;

        case S35: /* e.g. "2000F" */
            switch ((unsigned char) *p) {
            case 'e': state = S52; break;
            default:  return -1; /* leaf */
            }
            break;

        case S36: /* e.g. "2000A" */
            switch ((unsigned char) *p) {
            case 'u': state = S50; break;
            case 'p': state = S51; break;
            default:  return -1; /* leaf */
            }
            break;

        case S37: /* e.g. "2000-" */
            switch ((unsigned char) *p) {
            case 'J': state = S34; break;
            case 'F': state = S35; break;
            case 'A': state = S36; break;
            case 'O': state = S38; break;
            case 'S': state = S39; break;
            case 'N': state = S40; break;
            case 'D': state = S41; break;
            case 'M': state = S42; break;
            default:  return -1; /* leaf */
            }
            break;

        case S38: /* e.g. "2000O" */
            switch ((unsigned char) *p) {
            case 'c': state = S49; break;
            default:  return -1; /* leaf */
            }
            break;

        case S39: /* e.g. "2000S" */
            switch ((unsigned char) *p) {
            case 'e': state = S48; break;
            default:  return -1; /* leaf */
            }
            break;

        case S40: /* e.g. "2000N" */
            switch ((unsigned char) *p) {
            case 'o': state = S47; break;
            default:  return -1; /* leaf */
            }
            break;

        case S41: /* e.g. "2000D" */
            switch ((unsigned char) *p) {
            case 'e': state = S46; break;
            default:  return -1; /* leaf */
            }
            break;

        case S42: /* e.g. "2000M" */
            switch ((unsigned char) *p) {
            case 'a': state = S43; break;
            default:  return -1; /* leaf */
            }
            break;

        case S43: /* e.g. "2000Ma" */
            switch ((unsigned char) *p) {
            case 'r':
            case 'y': state = S44; break;
            default:  return -1; /* leaf */
            }
            break;

        case S44: /* e.g. "2000Dec" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3': state = S21; break;
            case '-': state = S45; break;
            default:  return -1; /* leaf */
            }
            break;

        case S45: /* e.g. "2000Dec-" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3': state = S21; break;
            default:  return -1; /* leaf */
            }
            break;

        case S46: /* e.g. "2000De" */
            switch ((unsigned char) *p) {
            case 'c': state = S44; break;
            default:  return -1; /* leaf */
            }
            break;

        case S47: /* e.g. "2000No" */
            switch ((unsigned char) *p) {
            case 'v': state = S44; break;
            default:  return -1; /* leaf */
            }
            break;

        case S48: /* e.g. "2000Se" */
            switch ((unsigned char) *p) {
            case 'p': state = S44; break;
            default:  return -1; /* leaf */
            }
            break;

        case S49: /* e.g. "2000Oc" */
            switch ((unsigned char) *p) {
            case 't': state = S44; break;
            default:  return -1; /* leaf */
            }
            break;

        case S50: /* e.g. "2000Au" */
            switch ((unsigned char) *p) {
            case 'g': state = S44; break;
            default:  return -1; /* leaf */
            }
            break;

        case S51: /* e.g. "2000Ap" */
            switch ((unsigned char) *p) {
            case 'r': state = S44; break;
            default:  return -1; /* leaf */
            }
            break;

        case S52: /* e.g. "2000Fe" */
            switch ((unsigned char) *p) {
            case 'b': state = S44; break;
            default:  return -1; /* leaf */
            }
            break;

        case S53: /* e.g. "2000Ju" */
            switch ((unsigned char) *p) {
            case 'l':
            case 'n': state = S44; break;
            default:  return -1; /* leaf */
            }
            break;

        case S54: /* e.g. "2000Ja" */
            switch ((unsigned char) *p) {
            case 'n': state = S44; break;
            default:  return -1; /* leaf */
            }
            break;

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S22: return 0x1; /* "([0123][0-9]-?(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-?(19|20)[0-9]{2}|(19|20)[0-9]{2}-?(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-?[0123][0-9])" */
    default: return -1; /* unexpected EOT */
    }
}

