
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3, S4, S5, S6, S7, S8, S9,
        S10, S11, S12
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case 'N': state = S1; break;
            case 'O': state = S2; break;
            case 'F': state = S3; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "N" */
            switch ((unsigned char) *p) {
            case 'e': state = S12; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "O" */
            switch ((unsigned char) *p) {
            case 'p': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S3: /* e.g. "F" */
            switch ((unsigned char) *p) {
            case 'r': state = S4; break;
            default:  return -1; /* leaf */
            }
            break;

        case S4: /* e.g. "Fr" */
            switch ((unsigned char) *p) {
            case 'e': state = S5; break;
            default:  return -1; /* leaf */
            }
            break;

        case S5: /* e.g. "Fre" */
            switch ((unsigned char) *p) {
            case 'e': state = S6; break;
            default:  return -1; /* leaf */
            }
            break;

        case S6: /* e.g. "Net" */
            switch ((unsigned char) *p) {
            case 'B': state = S7; break;
            default:  return -1; /* leaf */
            }
            break;

        case S7: /* e.g. "NetB" */
            switch ((unsigned char) *p) {
            case 'S': state = S8; break;
            default:  return -1; /* leaf */
            }
            break;

        case S8: /* e.g. "NetBS" */
            switch ((unsigned char) *p) {
            case 'D': state = S9; break;
            default:  return -1; /* leaf */
            }
            break;

        case S9: /* e.g. "NetBSD" */
            return -1; /* leaf */

        case S10: /* e.g. "Op" */
            switch ((unsigned char) *p) {
            case 'e': state = S11; break;
            default:  return -1; /* leaf */
            }
            break;

        case S11: /* e.g. "Ope" */
            switch ((unsigned char) *p) {
            case 'n': state = S6; break;
            default:  return -1; /* leaf */
            }
            break;

        case S12: /* e.g. "Ne" */
            switch ((unsigned char) *p) {
            case 't': state = S6; break;
            default:  return -1; /* leaf */
            }
            break;

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S9: return 0x1; /* "(Net|Open|Free)BSD" */
    default: return -1; /* unexpected EOT */
    }
}

