; QF - no quantifiers used
; A - arrays used
; BV - bitvectors
(set-logic QF_ABV)
(set-info :smt-lib-version 2.0)

;------------------------------
;00 01 02 | 03 04 05 | 06 07 08
;10 11 12 | 13 14 15 | 16 17 18
;20 21 22 | 23 24 25 | 26 27 28
;------------------------------
;30 31 32 | 33 34 35 | 36 37 38
;40 41 42 | 43 44 45 | 46 47 48
;50 51 52 | 53 54 55 | 56 57 58
;------------------------------
;60 61 62 | 63 64 65 | 66 67 68
;70 71 72 | 73 74 75 | 76 77 78
;80 81 82 | 83 84 85 | 86 87 88
;------------------------------

; each array index is a 8-bit byte
; high 4-bit - column, low 4-bit - row

(declare-const cells (Array (_ BitVec 8) (_ BitVec 4)))

; input - byte. high 4-bit - column, low 4-bit - row
; output - result of AND
(define-fun limits_for_cell
    (
        (arg1 (_ BitVec 8))
    )
    Bool
        (and
            (bvuge (select cells arg1) (_ bv1 4))
            (bvule (select cells arg1) (_ bv9 4))
        )
)

; input - 4-bit, column
(define-fun limits_for_col
    (
        (arg1 (_ BitVec 4)) ; input argument and its type
    )
    Bool ; output type
; enumerate all 9 rows in column:
    (and
       (limits_for_cell (concat arg1 #x0))
       (limits_for_cell (concat arg1 #x1))
       (limits_for_cell (concat arg1 #x2))
       (limits_for_cell (concat arg1 #x3))
       (limits_for_cell (concat arg1 #x4))
       (limits_for_cell (concat arg1 #x5))
       (limits_for_cell (concat arg1 #x6))
       (limits_for_cell (concat arg1 #x7))
       (limits_for_cell (concat arg1 #x8))
    )
)

; enumerate all 9 columns in Sudoku
; 'connect' output to always-true
(assert (limits_for_col #x0))
(assert (limits_for_col #x1))
(assert (limits_for_col #x2))
(assert (limits_for_col #x3))
(assert (limits_for_col #x4))
(assert (limits_for_col #x5))
(assert (limits_for_col #x6))
(assert (limits_for_col #x7))
(assert (limits_for_col #x8))

; each column must have distinct values:
(define-fun distinct_col
    (
        (arg1 (_ BitVec 4)) ; input argument and its type
    )
    Bool ; output type
    (distinct 
        (select cells (concat arg1 #x0))
        (select cells (concat arg1 #x1))
        (select cells (concat arg1 #x2))
        (select cells (concat arg1 #x3))
        (select cells (concat arg1 #x4))
        (select cells (concat arg1 #x5))
        (select cells (concat arg1 #x6))
        (select cells (concat arg1 #x7))
        (select cells (concat arg1 #x8))
    )
)

; 'connect' output to always-true
(assert (distinct_col #x0))
(assert (distinct_col #x1))
(assert (distinct_col #x2))
(assert (distinct_col #x3))
(assert (distinct_col #x4))
(assert (distinct_col #x5))
(assert (distinct_col #x6))
(assert (distinct_col #x7))
(assert (distinct_col #x8))

; each row must have distinct values:
(define-fun distinct_row
    (
        (arg1 (_ BitVec 4)) ; input argument and its type
    )
    Bool ; output type
    (distinct 
        (select cells (concat #x0 arg1))
        (select cells (concat #x1 arg1))
        (select cells (concat #x2 arg1))
        (select cells (concat #x3 arg1))
        (select cells (concat #x4 arg1))
        (select cells (concat #x5 arg1))
        (select cells (concat #x6 arg1))
        (select cells (concat #x7 arg1))
        (select cells (concat #x8 arg1))
    )
)

; 'connect' output to always-true
(assert (distinct_row #x0))
(assert (distinct_row #x1))
(assert (distinct_row #x2))
(assert (distinct_row #x3))
(assert (distinct_row #x4))
(assert (distinct_row #x5))
(assert (distinct_row #x6))
(assert (distinct_row #x7))
(assert (distinct_row #x8))

; 9 values inside of 3*3 block must be distinct:
(define-fun distinct_block
    (
        (arg1 (_ BitVec 4)) ; two input arguments and their types
        (arg2 (_ BitVec 4))
    )
    Bool ; output type
    (distinct 
        (select cells (concat (bvadd arg1 #x0) (bvadd arg2 #x0)))
        (select cells (concat (bvadd arg1 #x0) (bvadd arg2 #x1)))
        (select cells (concat (bvadd arg1 #x0) (bvadd arg2 #x2)))
        (select cells (concat (bvadd arg1 #x1) (bvadd arg2 #x0)))
        (select cells (concat (bvadd arg1 #x1) (bvadd arg2 #x1)))
        (select cells (concat (bvadd arg1 #x1) (bvadd arg2 #x2)))
        (select cells (concat (bvadd arg1 #x2) (bvadd arg2 #x0)))
        (select cells (concat (bvadd arg1 #x2) (bvadd arg2 #x1)))
        (select cells (concat (bvadd arg1 #x2) (bvadd arg2 #x2)))
    )
)

; enumerate all 9 3*3 blocks.
; 'connect' output to always-true
(assert (distinct_block #x0 #x0))
(assert (distinct_block #x0 #x3))
(assert (distinct_block #x0 #x6))
(assert (distinct_block #x3 #x0))
(assert (distinct_block #x3 #x3))
(assert (distinct_block #x3 #x6))
(assert (distinct_block #x6 #x0))
(assert (distinct_block #x6 #x3))
(assert (distinct_block #x6 #x6))

; http://www.norvig.com/sudoku.html
; http://www.mirror.co.uk/news/weird-news/worlds-hardest-sudoku-can-you-242294

;..53..... - 0
;8......2. - 1
;.7..1.5.. - 2
;4....53.. - 3
;.1..7...6 - 4
;..32...8. - 5
;.6.5....9 - 6
;..4....3. - 7
;.....97.. - 8

; set input:
(assert (= (select cells #x02) #x5))
(assert (= (select cells #x03) #x3))
(assert (= (select cells #x10) #x8))
(assert (= (select cells #x17) #x2))
(assert (= (select cells #x21) #x7))
(assert (= (select cells #x24) #x1))
(assert (= (select cells #x26) #x5))
(assert (= (select cells #x30) #x4))
(assert (= (select cells #x35) #x5))
(assert (= (select cells #x36) #x3))
(assert (= (select cells #x41) #x1))
(assert (= (select cells #x44) #x7))
(assert (= (select cells #x48) #x6))
(assert (= (select cells #x52) #x3))
(assert (= (select cells #x53) #x2))
(assert (= (select cells #x57) #x8))
(assert (= (select cells #x61) #x6))
(assert (= (select cells #x63) #x5))
(assert (= (select cells #x68) #x9))
(assert (= (select cells #x72) #x4))
(assert (= (select cells #x77) #x3))
(assert (= (select cells #x84) #x9))
(assert (= (select cells #x86) #x7))

(check-sat)
(get-model)

