; tested with Z3

; prove that XOR swap algorithm 
; (using addition/subtraction) is correct.
; https://en.wikipedia.org/wiki/XOR_swap_algorithm

; initial: X1, Y1
;X2 := X1 ADD Y1
;Y3 := X2 SUB Y1
;X4 := X2 SUB Y3
; prove X1=Y3 and Y1=X4 for all

; must be unsat, of course

(set-logic QF_LIA)
(set-info :smt-lib-version 2.0)

(declare-fun x1 () Int)
(declare-fun y1 () Int)
(declare-fun x2 () Int)
(declare-fun y3 () Int)
(declare-fun x4 () Int)

(assert (= x2 (+ x1 y1)))
(assert (= y3 (- x2 y1)))
(assert (= x4 (- x2 y3)))

(assert (not (and (= x4 y1) (= y3 x1))))

(check-sat)

