/*
 * This file is part of the Yices SMT Solver.
 * Copyright (C) 2017 SRI International.

...

/*
 * Codes for the logic (based on benchmarks available in June 2009)
 * + one special code 'NONE' for propositional logic
 *
 * 06/03/2014: More surprise logics for SMTCOMP 2014
 *
 * 06/18/2014: Attempt to be a bit more systematic
 * -----------------------------------------------
 * Added all the logics listed at smt-lib.org + a few more that should be there.
 *
 * The base theories are:
 *    AX: arrays
 *    BV: bitvectors
 *    UF: uninterpreted types and functions
 *  + arithmetic
 *
 * For arithmetic:
 * - the domain can be Int or Reals or Both (mixed arithmetic)
 * - the type of atoms can be
 *   difference logic
 *   linear equalities and inequalities
 *   non-linear equalities and inequalities (polynomials)
 * - this gives nine arithmetic variants, but the standard does not include
 *   mixed difference logic. So we have eight arithmetic codes:
 *   IDL, RDL, LIA, LRA, LIRA, NIA, NRA, NIRA
 *
 * AX + UF can be combined with BV and with one of the arithmetic fragments
 * (except that we don't have AIDL and ARDL?).
 *
 * Then, for each logic, we have a quantifier-free variant.
 */
typedef enum smt_logic {
  NONE,        // added 12/27/2012

  /*
   * Base logics (with quantifiers)
   */
  AX,          // arrays
  BV,          // bitvectors
  IDL,         // integer difference logic
  LIA,         // linear integer arithmetic
  LRA,         // linear real arithmetic
  LIRA,        // mixed linear arithmetic
  NIA,         // non-linear integer arithmetic
  NRA,         // non-linear real arithmetic
  NIRA,        // non-linear mixed arithmetic
  RDL,         // real difference logic
  UF,          // uninterpreted functions

  //  Arrays + some other theory
  ABV,         // arrays + bitvectors
  ALIA,        // arrays + linear integer arithmetic
  ALRA,        // arrays + linear real arithmetic
  ALIRA,       // arrays + mixed linear arithmetic
  ANIA,        // arrays + non-linear integer arithmetic
  ANRA,        // arrays + non-linear real arithmetic
  ANIRA,       // arrays + mixed/non-linear arithmetic
  AUF,         // arrays + uninterpreted functions

  //  Uninterpreted function + another theory
  UFBV,        // uninterpreted functions + bitvectors
  UFIDL,       // uninterpreted functions + integer difference logic
  UFLIA,       // uninterpreted functions + linear integer arithmetic
  UFLRA,       // uninterpreted functions + linear real arithmetic
  UFLIRA,      // uninterpreted functions + mixed linear arithmetic
  UFNIA,       // uninterpreted functions + non-linear integer arithmetic
  UFNRA,       // uninterpreted functions + non-linear real arithmetic
  UFNIRA,      // uninterpreted functions + mixed, non-linear arithmetic
  UFRDL,       // uninterpreted functions + real difference logic

  //  Arrays + uninterpreted functions + another theory
  AUFBV,       // arrays + uninterpreted functions + bitvectors
  AUFLIA,      // arrays + uninterpreted functions + linear integer arithmetic
  AUFLRA,      // arrays + uninterpreted functions + linear real arithmetic
  AUFLIRA,     // arrays + uninterpreted functions + mixed linear arithmetic
  AUFNIA,      // arrays + uninterpreted functions + non-linear integer arithmetic
  AUFNRA,      // arrays + uninterpreted functions + non-linear real arithmetic
  AUFNIRA,     // arrays + uninterpreted functions + mixed, non-linear arithmetic

  /*
   * Quantifier-free fragments
   */
  QF_AX,       // arrays
  QF_BV,       // bitvectors
  QF_IDL,      // integer difference logic
  QF_LIA,      // linear integer arithmetic
  QF_LRA,      // linear real arithmetic
  QF_LIRA,     // mixed linear arithmetic
  QF_NIA,      // non-linear integer arithmetic
  QF_NRA,      // non-linear real arithmetic
  QF_NIRA,     // non-linear mixed arithmetic
  QF_RDL,      // real difference logic
  QF_UF,       // uninterpreted functions

  //  Arrays + some other theory
  QF_ABV,      // arrays + bitvectors
  QF_ALIA,     // arrays + linear integer arithmetic
  QF_ALRA,     // arrays + linear real arithmetic
  QF_ALIRA,    // arrays + mixed linear arithmetic
  QF_ANIA,     // arrays + non-linear integer arithmetic
  QF_ANRA,     // arrays + non-linear real arithmetic
  QF_ANIRA,    // arrays + mixed/non-linear arithmetic
  QF_AUF,      // arrays + uninterpreted functions

  //  Uninterpreted function + another theory
  QF_UFBV,     // uninterpreted functions + bitvectors
  QF_UFIDL,    // uninterpreted functions + integer difference logic
  QF_UFLIA,    // uninterpreted functions + linear integer arithmetic
  QF_UFLRA,    // uninterpreted functions + linear real arithmetic
  QF_UFLIRA,   // uninterpreted functions + mixed linear arithmetic
  QF_UFNIA,    // uninterpreted functions + non-linear integer arithmetic
  QF_UFNRA,    // uninterpreted functions + non-linear real arithmetic
  QF_UFNIRA,   // uninterpreted functions + mixed, non-linear arithmetic
  QF_UFRDL,    // uninterpreted functions + real difference logic

  //  Arrays + uninterpreted functions + another theory
  QF_AUFBV,    // arrays + uninterpreted functions + bitvectors
  QF_AUFLIA,   // arrays + uninterpreted functions + linear integer arithmetic
  QF_AUFLRA,   // arrays + uninterpreted functions + linear real arithmetic
  QF_AUFLIRA,  // arrays + uninterpreted functions + mixed linear arithmetic
  QF_AUFNIA,   // arrays + uninterpreted functions + non-linear integer arithmetic
  QF_AUFNRA,   // arrays + uninterpreted functions + non-linear real arithmetic
  QF_AUFNIRA,  // arrays + uninterpreted functions + mixed, non-linear arithmetic

...

/*
 * Arithmetic fragments
 */
typedef enum arith_fragment {
  ARITH_IDL,   // integer difference logic
  ARITH_RDL,   // real difference logic
  ARITH_LIA,   // linear integer arithmetic
  ARITH_LRA,   // linear real arithmetic
  ARITH_LIRA,  // linear mixed arithmetic
  ARITH_NIA,   // non-linear integer arithmetic
  ARITH_NRA,   // non-linear real arithmetic
  ARITH_NIRA,  // non-linear mixed arithmetic
  ARITH_NONE,  // no arithmetic
} arith_fragment_t;

