#include <stdint.h>
#include <stdbool.h>
#include <assert.h>

// CRC-64-ECMA in https://en.wikipedia.org/wiki/Cyclic_redundancy_check
uint64_t crc64(uint64_t crc, unsigned char *buf, int len)
{
    int k;

    crc = ~crc;
    while (len--)
    {
        crc ^= *buf++;
        for (k = 0; k < 8; k++)
            crc = crc & 1 ? (crc >> 1) ^ 0xC96C5795D7870F42 : crc >> 1;
    }
    return ~crc;
}

#define SIZE 14

void main()
{
        char str[SIZE];

        int i=0;
        for (i=0; i<SIZE; i++)
        {
                if (str[i]<'a')
                        return;
                if (str[i]>'z')
                        return;
        };

    if (crc64(0, &str[0], SIZE)==0)
                assert (0);
};

