unsigned search_cocos_brute (char *s, unsigned len)
{
    if (len<5)
        return len;  // not found
    for (unsigned i=0; i<len-4; i++)
    {
        if (s[i]=='c' &&
                s[i+1]=='o' &&
                s[i+2]=='c' &&
                s[i+3]=='o' &&
                s[i+4]=='s')
            return i; // found
    };
    return len;      // not found
};

unsigned search_cocos_naive (char *s, unsigned len)
{
    if (len<5)
        return len;  // not found
    unsigned seen=0;
    for (unsigned i=0; i<len; i++)
    {
        char ch=s[i]; // this is single read operation
        if (seen==0 && ch=='c')
            seen=1;
        else if (seen==1 && ch=='o')
            seen=2;
        else if (seen==2 && ch=='c')
            seen=3;
        else if (seen==3 && ch=='o')
            seen=4;
        else if (seen==4 && ch=='s')
            return i-4;  // found
        else
            seen=0;      // reset
    }
    return len;      // not found
};

void check()
{
    unsigned len=LEN;
    char s[len];
    __CPROVER_assert (search_cocos_brute(s, len)==search_cocos_naive(s, len), "assert");
};
