
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3, S4, S5, S6, S7, S8, S9,
        S10
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case 'S':
            case 's': state = S1; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "s" */
            switch ((unsigned char) *p) {
            case 't': state = S2; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "st" */
            switch ((unsigned char) *p) {
            case 'e': state = S3; break;
            default:  return -1; /* leaf */
            }
            break;

        case S3: /* e.g. "ste" */
            switch ((unsigned char) *p) {
            case 'p': state = S4; break;
            case 'v': state = S5; break;
            default:  return -1; /* leaf */
            }
            break;

        case S4: /* e.g. "step" */
            switch ((unsigned char) *p) {
            case 'h': state = S9; break;
            default:  return -1; /* leaf */
            }
            break;

        case S5: /* e.g. "stev" */
            switch ((unsigned char) *p) {
            case 'e': state = S6; break;
            case 'i': state = S7; break;
            default:  return -1; /* leaf */
            }
            break;

        case S6: /* e.g. "steve" */
            switch ((unsigned char) *p) {
            case 'n': state = S8; break;
            default:  return -1; /* leaf */
            }
            break;

        case S7: /* e.g. "stevi" */
            switch ((unsigned char) *p) {
            case 'e': state = S8; break;
            default:  return -1; /* leaf */
            }
            break;

        case S8: /* e.g. "stevie" */
            return -1; /* leaf */

        case S9: /* e.g. "steph" */
            switch ((unsigned char) *p) {
            case 'e': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S10: /* e.g. "stephe" */
            switch ((unsigned char) *p) {
            case 'n': state = S8; break;
            default:  return -1; /* leaf */
            }
            break;

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S6: return 0x1; /* "(s|S)t(even|ephen|eve|evie)" */
    case S8: return 0x1; /* "(s|S)t(even|ephen|eve|evie)" */
    default: return -1; /* unexpected EOT */
    }
}

