
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3, S4, S5
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case '\t':
            case ' ': break;
            case 'a':
            case 'b':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            case 's':
            case 't':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z': state = S1; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "a" */
            switch ((unsigned char) *p) {
            case 'a':
            case 'b':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            case 's':
            case 't':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z': break;
            case '=': state = S2; break;
            case '\t':
            case ' ': state = S3; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "a=" */
            switch ((unsigned char) *p) {
            case '\t':
            case ' ': break;
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S4; break;
            default:  return -1; /* leaf */
            }
            break;

        case S3: /* e.g. "a\\x09" */
            switch ((unsigned char) *p) {
            case '=': state = S2; break;
            case '\t':
            case ' ': break;
            default:  return -1; /* leaf */
            }
            break;

        case S4: /* e.g. "a=0" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': break;
            case '\t':
            case ' ': state = S5; break;
            default:  return -1; /* leaf */
            }
            break;

        case S5: /* e.g. "a=0" */
            switch ((unsigned char) *p) {
            case '\t':
            case ' ': break;
            default:  return -1; /* leaf */
            }
            break;

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S4: return 0x1; /* "[ \t]*[a-z]+[ \t]*=[ \t]*[0-9]+[ \t]*" */
    case S5: return 0x1; /* "[ \t]*[a-z]+[ \t]*=[ \t]*[0-9]+[ \t]*" */
    default: return -1; /* unexpected EOT */
    }
}

