(set-logic QF_ABV)
(set-info :smt-lib-version 2.0)

(declare-fun const1 () (_ BitVec 32))
(assert (= const1 (_ bv214013 32)))
(declare-fun const2 () (_ BitVec 32))
(assert (= const2 (_ bv2531011 32)))

(declare-const states (Array (_ BitVec 4) (_ BitVec 32)))
(declare-fun init () (_ BitVec 32))
(assert (= init (select states #x1)))
(assert (not (= init (_ bv1942745908 32))))

(define-fun PRNG_step 
    ((state (_ BitVec 32))) ; list of arguments
    (_ BitVec 32)           ; type of return value
    (bvadd (bvmul state const1) const2) ; body
)

(define-fun PRNG_get_result_modulo
    ((state (_ BitVec 32))) ; list of arguments
    (_ BitVec 32)           ; type of return value
    (bvand (bvlshr state (_ bv16 32)) #x00007fff) ; body
)

(define-fun PRNG_get_result_modulo_1000
    ((state (_ BitVec 32))) ; list of arguments
    (_ BitVec 32)           ; type of return value
    (bvurem (PRNG_get_result_modulo state) (_ bv1000 32)) ; body
)

(assert (= (PRNG_step (select states #x1)) (select states #x2)))
(assert (= (PRNG_step (select states #x2)) (select states #x3)))
(assert (= (PRNG_step (select states #x3)) (select states #x4)))

(assert (= (PRNG_get_result_modulo_1000 (select states #x2)) (_ bv0 32)))
(assert (= (PRNG_get_result_modulo_1000 (select states #x3)) (_ bv0 32)))
(assert (= (PRNG_get_result_modulo_1000 (select states #x4)) (_ bv0 32)))

(check-sat)
(get-model)
