#!/usr/bin/env bash

gf2_factor_test ()
{
    echo "* poly $1"
    echo "** running for SAT"
    ./gf2_factor_SAT.py $1
    echo "** running for Z3"
    ./gf2_factor_z3.py  $1
}

# MSB is always 1 in CRC polynomials, and it's omitted
# but we add it here (leading 1 bit):

gf2_factor_test 0x5 # reducible
gf2_factor_test 0x7 # irreducible

# Both irreducible [from Colbourn, Dinitz - Handbook of Combinatorial Designs (2ed, 2007), p.809]
gf2_factor_test 0x409 # 10000001001
gf2_factor_test 0x40f # 10000001111 

gf2_factor_test 0x11021 # CRC-16-CCITT, reducible
gf2_factor_test 0x18005 # CRC-16-IBM, reducible
gf2_factor_test 0x1C867 # CRC-16-CDMA2000, irreducible

gf2_factor_test 0x104c11db7 # CRC-32, irreducible
gf2_factor_test 0x11EDC6F41 # CRC-32C (Castagnoli), CRC32 x86 instruction, reducible
gf2_factor_test 0x132583499 # CRC-32K2 (Koopman {1,1,30}), reducible
gf2_factor_test 0x1741B8CD7 # CRC-32K (Koopman {1,3,28}), reducible
gf2_factor_test 0x1814141AB # CRC-32Q, reducible

gf2_factor_test 0x142F0E1EBA9EA3693 # CRC-64-ECMA - reducible
#0x1000000000000001B # CRC-64-ISO. timeout

#0x100000000000000000000000000000087 # AES-GCM (not CRC)

