; (handcrafted file)

(set-logic QF_BV)

; tested with Z3, CVC4, Boolector

; 1000 seconds (~15 minutes) timeout:
; time z3 -T:1000 -smt2 1.smt
; time cvc4 --tlimit=1000000 --lang=smt2 1.smt
; time boolector -t 1000 --smt2 1.smt

; for CVC4 and Boolector, to enable (get-model):
; (set-option :produce-models true)

(declare-fun c0 () (_ BitVec 64)) (assert (= c0 (_ bv0 64))) ; always 0
(declare-fun c1 () (_ BitVec 64)) (assert (= c1 (_ bv1 64))) ; always 1

(declare-fun m1  () (_ BitVec 64)) (assert (= m1 #x5555555555555555))
(declare-fun m2  () (_ BitVec 64)) (assert (= m2 #x3333333333333333))
(declare-fun m4  () (_ BitVec 64)) (assert (= m4 #x0f0f0f0f0f0f0f0f))
(declare-fun m8  () (_ BitVec 64)) (assert (= m8 #x00ff00ff00ff00ff))
(declare-fun m16 () (_ BitVec 64)) (assert (= m16 #x0000ffff0000ffff))
(declare-fun m32 () (_ BitVec 64)) (assert (= m32 #x00000000ffffffff))

;int popcount64a(uint64_t x)
;{
;   x = (x & m1 ) + ((x >>  1) & m1 );
;   x = (x & m2 ) + ((x >>  2) & m2 );
;   x = (x & m4 ) + ((x >>  4) & m4 );
;   x = (x & m8 ) + ((x >>  8) & m8 );
;   x = (x & m16) + ((x >> 16) & m16);
;   x = (x & m32) + ((x >> 32) & m32);
;   return x;
;}

(declare-fun a_x () (_ BitVec 64))
(declare-fun a_x1 () (_ BitVec 64))
(declare-fun a_x2 () (_ BitVec 64))
(declare-fun a_x3 () (_ BitVec 64))
(declare-fun a_x4 () (_ BitVec 64))
(declare-fun a_x5 () (_ BitVec 64))
(declare-fun a_out () (_ BitVec 64))

(assert (= a_x1  (bvadd (bvand a_x m1)   (bvand (bvlshr a_x  (_ bv1 64)) m1))))
(assert (= a_x2  (bvadd (bvand a_x1 m2)  (bvand (bvlshr a_x1 (_ bv2 64)) m2))))
(assert (= a_x3  (bvadd (bvand a_x2 m4)  (bvand (bvlshr a_x2 (_ bv4 64)) m4))))
(assert (= a_x4  (bvadd (bvand a_x3 m8)  (bvand (bvlshr a_x3 (_ bv8 64)) m8))))
(assert (= a_x5  (bvadd (bvand a_x4 m16) (bvand (bvlshr a_x4 (_ bv16 64)) m16))))
(assert (= a_out (bvadd (bvand a_x5 m32) (bvand (bvlshr a_x5 (_ bv32 64)) m32))))

(declare-fun naive_x () (_ BitVec 64))
(declare-fun naive_out () (_ BitVec 64))

; popcount64(): naive way:
; (x>>0)&1 + (x>>1)&1 + (x>>2)&1 + ...

(assert (= naive_out
(bvadd 
       (bvand (bvlshr naive_x (_ bv0 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv1 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv2 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv3 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv4 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv5 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv6 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv7 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv8 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv9 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv10 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv11 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv12 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv13 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv14 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv15 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv16 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv17 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv18 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv19 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv20 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv21 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv22 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv23 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv24 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv25 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv26 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv27 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv28 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv29 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv30 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv31 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv32 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv33 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv34 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv35 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv36 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv37 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv38 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv39 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv40 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv41 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv42 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv43 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv44 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv45 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv46 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv47 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv48 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv49 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv50 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv51 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv52 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv53 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv54 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv55 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv56 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv57 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv58 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv59 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv60 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv61 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv62 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv63 64)) (_ bv1 64))
)))

; Boolector: 15s
; CVC4: ~1m
; Z3: ~1s
(assert (= naive_x a_x)) (assert (not (= naive_out a_out)))

(check-sat)
