
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3, S4, S5, S6, S7, S8, S9
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case '\t':
            case ' ': break;
            case 'v': state = S1; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "v" */
            switch ((unsigned char) *p) {
            case 'a': state = S2; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "va" */
            switch ((unsigned char) *p) {
            case 'r': state = S3; break;
            default:  return -1; /* leaf */
            }
            break;

        case S3: /* e.g. "var" */
            switch ((unsigned char) *p) {
            case '1': state = S4; break;
            default:  return -1; /* leaf */
            }
            break;

        case S4: /* e.g. "var1" */
            switch ((unsigned char) *p) {
            case '\t':
            case ' ': break;
            case '=': state = S5; break;
            default:  return -1; /* leaf */
            }
            break;

        case S5: /* e.g. "var1=" */
            switch ((unsigned char) *p) {
            case '\t':
            case ' ': break;
            case 'v': state = S6; break;
            default:  return -1; /* leaf */
            }
            break;

        case S6: /* e.g. "var1=v" */
            switch ((unsigned char) *p) {
            case 'a': state = S7; break;
            default:  return -1; /* leaf */
            }
            break;

        case S7: /* e.g. "var1=va" */
            switch ((unsigned char) *p) {
            case 'r': state = S8; break;
            default:  return -1; /* leaf */
            }
            break;

        case S8: /* e.g. "var1=var" */
            switch ((unsigned char) *p) {
            case '2': state = S9; break;
            default:  return -1; /* leaf */
            }
            break;

        case S9: /* e.g. "var1=var2" */
            switch ((unsigned char) *p) {
            case '\t':
            case ' ': break;
            default:  return -1; /* leaf */
            }
            break;

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S9: return 0x1; /* "[ \t]*var1[ \t]*=[ \t]*var2[ \t]*" */
    default: return -1; /* unexpected EOT */
    }
}

