
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3, S4, S5, S6, S7, S8, S9,
        S10, S11, S12, S13, S14, S15, S16, S17, S18, S19,
        S20, S21
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case 'r': state = S1; break;
            case 'b': state = S2; break;
            case 'l': state = S3; break;
            case 'd': state = S4; break;
            case 'g': state = S5; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "r" */
            switch ((unsigned char) *p) {
            case 'e': state = S21; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "b" */
            switch ((unsigned char) *p) {
            case 'l': state = S19; break;
            default:  return -1; /* leaf */
            }
            break;

        case S3: /* e.g. "l" */
            switch ((unsigned char) *p) {
            case 'i': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S4: /* e.g. "d" */
            switch ((unsigned char) *p) {
            case 'a': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S5: /* e.g. "g" */
            switch ((unsigned char) *p) {
            case 'r': state = S6; break;
            default:  return -1; /* leaf */
            }
            break;

        case S6: /* e.g. "gr" */
            switch ((unsigned char) *p) {
            case 'e': state = S7; break;
            default:  return -1; /* leaf */
            }
            break;

        case S7: /* e.g. "gre" */
            switch ((unsigned char) *p) {
            case 'e': state = S8; break;
            default:  return -1; /* leaf */
            }
            break;

        case S8: /* e.g. "gree" */
            switch ((unsigned char) *p) {
            case 'n': state = S9; break;
            default:  return -1; /* leaf */
            }
            break;

        case S9: /* e.g. "red" */
            switch ((unsigned char) *p) {
            case 'i': state = S10; break;
            default:  return -1; /* leaf */
            }
            break;

        case S10: /* e.g. "redi" */
            switch ((unsigned char) *p) {
            case 's': state = S11; break;
            default:  return -1; /* leaf */
            }
            break;

        case S11: /* e.g. "redis" */
            switch ((unsigned char) *p) {
            case 'h': state = S12; break;
            default:  return -1; /* leaf */
            }
            break;

        case S12: /* e.g. "redish" */
            return -1; /* leaf */

        case S13: /* e.g. "da" */
            switch ((unsigned char) *p) {
            case 'r': state = S14; break;
            default:  return -1; /* leaf */
            }
            break;

        case S14: /* e.g. "dar" */
            switch ((unsigned char) *p) {
            case 'k': state = S15; break;
            default:  return -1; /* leaf */
            }
            break;

        case S15: /* e.g. "dark" */
            switch ((unsigned char) *p) {
            case 'r': state = S1; break;
            case 'b': state = S2; break;
            case 'g': state = S5; break;
            default:  return -1; /* leaf */
            }
            break;

        case S16: /* e.g. "li" */
            switch ((unsigned char) *p) {
            case 'g': state = S17; break;
            default:  return -1; /* leaf */
            }
            break;

        case S17: /* e.g. "lig" */
            switch ((unsigned char) *p) {
            case 'h': state = S18; break;
            default:  return -1; /* leaf */
            }
            break;

        case S18: /* e.g. "ligh" */
            switch ((unsigned char) *p) {
            case 't': state = S15; break;
            default:  return -1; /* leaf */
            }
            break;

        case S19: /* e.g. "bl" */
            switch ((unsigned char) *p) {
            case 'u': state = S20; break;
            default:  return -1; /* leaf */
            }
            break;

        case S20: /* e.g. "blu" */
            switch ((unsigned char) *p) {
            case 'e': state = S9; break;
            default:  return -1; /* leaf */
            }
            break;

        case S21: /* e.g. "re" */
            switch ((unsigned char) *p) {
            case 'd': state = S9; break;
            default:  return -1; /* leaf */
            }
            break;

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S9: return 0x1; /* "(dark|light)?(red|green|blue)(ish)?" */
    case S12: return 0x1; /* "(dark|light)?(red|green|blue)(ish)?" */
    default: return -1; /* unexpected EOT */
    }
}

