
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3, S4, S5, S6
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case 'c': state = S1; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "c" */
            switch ((unsigned char) *p) {
            case 'o': state = S2; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "co" */
            switch ((unsigned char) *p) {
            case 'l': state = S3; break;
            default:  return -1; /* leaf */
            }
            break;

        case S3: /* e.g. "col" */
            switch ((unsigned char) *p) {
            case 'o': state = S4; break;
            default:  return -1; /* leaf */
            }
            break;

        case S4: /* e.g. "colo" */
            switch ((unsigned char) *p) {
            case 'u': state = S5; break;
            case 'r': state = S6; break;
            default:  return -1; /* leaf */
            }
            break;

        case S5: /* e.g. "colou" */
            switch ((unsigned char) *p) {
            case 'r': state = S6; break;
            default:  return -1; /* leaf */
            }
            break;

        case S6: /* e.g. "color" */
            return -1; /* leaf */

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S6: return 0x1; /* "colou?r" */
    default: return -1; /* unexpected EOT */
    }
}

