
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3, S4
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case 'M': state = S1; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "M" */
            switch ((unsigned char) *p) {
            case 'r': state = S2; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "Mr" */
            switch ((unsigned char) *p) {
            case 's': state = S3; break;
            case '.': state = S4; break;
            default:  return -1; /* leaf */
            }
            break;

        case S3: /* e.g. "Mrs" */
            switch ((unsigned char) *p) {
            case '.': state = S4; break;
            default:  return -1; /* leaf */
            }
            break;

        case S4: /* e.g. "Mr." */
            return -1; /* leaf */

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S4: return 0x1; /* "M(r|rs)\." */
    default: return -1; /* unexpected EOT */
    }
}

