(set-logic QF_BV)
(set-info :smt-lib-version 2.0)

(declare-fun const1 () (_ BitVec 32))
(assert (= const1 (_ bv214013 32)))
(declare-fun const2 () (_ BitVec 32))
(assert (= const2 (_ bv2531011 32)))

(declare-fun state1 () (_ BitVec 32))
(declare-fun state2 () (_ BitVec 32))
(declare-fun state3 () (_ BitVec 32))
(declare-fun state4 () (_ BitVec 32))

(define-fun PRNG_step 
    ((state (_ BitVec 32))) ; list of arguments
    (_ BitVec 32)           ; type of return value
    (bvadd (bvmul state const1) const2) ; body
)

(define-fun PRNG_get_result_modulo
    ((state (_ BitVec 32))) ; list of arguments
    (_ BitVec 32)           ; type of return value
    (bvand (bvlshr state (_ bv16 32)) #x00007fff) ; body
)

(define-fun PRNG_get_result_modulo_1000
    ((state (_ BitVec 32))) ; list of arguments
    (_ BitVec 32)           ; type of return value
    (bvurem (PRNG_get_result_modulo state) (_ bv1000 32)) ; body
)

(assert (= (PRNG_step state1) state2))
(assert (= (PRNG_step state2) state3))
(assert (= (PRNG_step state3) state4))

(assert (= (PRNG_get_result_modulo_1000 state2) (_ bv0 32)))
(assert (= (PRNG_get_result_modulo_1000 state3) (_ bv0 32)))
(assert (= (PRNG_get_result_modulo_1000 state4) (_ bv0 32)))

; two correct solutions:
;(assert (not (= state1 #xf3cbf334)))
;(assert (not (= state1 #x73cbf334)))

(check-sat)
(get-model)
