; (handcrafted file)

; proving equivalence of several 64-bit population count functions
; https://yurichev.com/news/20200416_popcount/

(set-info :smt-lib-version 2.6)
(set-logic QF_BV)
(set-info :source |
Generated by: Dennis Yurichev
Generated on: 16-Apr-2020
Application: Proving equivalence of several 64-bit population count functions
Target solver: Boolector, Z3, CVC4
|)
(set-info :license "https://creativecommons.org/licenses/by/4.0/")
(set-info :category "handcrafted")
(set-info :status unsat)

; tested with Z3, CVC4, Boolector

; 1000 seconds (~15 minutes) timeout:
; time z3 -T:1000 -smt2 1.smt
; time cvc4 --tlimit=1000000 --lang=smt2 1.smt
; time boolector -t 1000 --smt2 1.smt

; Boolector: 80s
; CVC4, Z3: timeout

; for CVC4 and Boolector, to enable (get-model):
; (set-option :produce-models true)

(declare-fun c0 () (_ BitVec 64)) (assert (= c0 (_ bv0 64))) ; always 0
(declare-fun c1 () (_ BitVec 64)) (assert (= c1 (_ bv1 64))) ; always 1

(declare-fun naive_x () (_ BitVec 64))
(declare-fun naive_out () (_ BitVec 64))

; popcount64(): naive way:
; (x>>0)&1 + (x>>1)&1 + (x>>2)&1 + ...

(assert (= naive_out
(bvadd 
       (bvand (bvlshr naive_x (_ bv0 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv1 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv2 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv3 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv4 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv5 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv6 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv7 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv8 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv9 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv10 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv11 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv12 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv13 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv14 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv15 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv16 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv17 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv18 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv19 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv20 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv21 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv22 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv23 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv24 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv25 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv26 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv27 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv28 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv29 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv30 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv31 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv32 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv33 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv34 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv35 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv36 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv37 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv38 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv39 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv40 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv41 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv42 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv43 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv44 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv45 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv46 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv47 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv48 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv49 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv50 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv51 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv52 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv53 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv54 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv55 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv56 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv57 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv58 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv59 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv60 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv61 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv62 64)) (_ bv1 64))
       (bvand (bvlshr naive_x (_ bv63 64)) (_ bv1 64))
)))

; Kernighan's unrolled...

;   int count=0;
;   if (x) {x &= x-1; count++;};if (x) {x &= x-1; count++;};if (x) {x &= x-1; count++;};if (x) {x &= x-1; count++;};
;   if (x) {x &= x-1; count++;};if (x) {x &= x-1; count++;};if (x) {x &= x-1; count++;};if (x) {x &= x-1; count++;};

(declare-fun kern_x0 () (_ BitVec 64))
(declare-fun kern_x1 () (_ BitVec 64))
(assert (= kern_x1 (ite (= kern_x0 c0) kern_x0 (bvand kern_x0 (bvsub kern_x0 c1)))))
(declare-fun kern_x2 () (_ BitVec 64))
(assert (= kern_x2 (ite (= kern_x1 c0) kern_x1 (bvand kern_x1 (bvsub kern_x1 c1)))))
(declare-fun kern_x3 () (_ BitVec 64))
(assert (= kern_x3 (ite (= kern_x2 c0) kern_x2 (bvand kern_x2 (bvsub kern_x2 c1)))))
(declare-fun kern_x4 () (_ BitVec 64))
(assert (= kern_x4 (ite (= kern_x3 c0) kern_x3 (bvand kern_x3 (bvsub kern_x3 c1)))))
(declare-fun kern_x5 () (_ BitVec 64))
(assert (= kern_x5 (ite (= kern_x4 c0) kern_x4 (bvand kern_x4 (bvsub kern_x4 c1)))))
(declare-fun kern_x6 () (_ BitVec 64))
(assert (= kern_x6 (ite (= kern_x5 c0) kern_x5 (bvand kern_x5 (bvsub kern_x5 c1)))))
(declare-fun kern_x7 () (_ BitVec 64))
(assert (= kern_x7 (ite (= kern_x6 c0) kern_x6 (bvand kern_x6 (bvsub kern_x6 c1)))))
(declare-fun kern_x8 () (_ BitVec 64))
(assert (= kern_x8 (ite (= kern_x7 c0) kern_x7 (bvand kern_x7 (bvsub kern_x7 c1)))))
(declare-fun kern_x9 () (_ BitVec 64))
(assert (= kern_x9 (ite (= kern_x8 c0) kern_x8 (bvand kern_x8 (bvsub kern_x8 c1)))))
(declare-fun kern_x10 () (_ BitVec 64))
(assert (= kern_x10 (ite (= kern_x9 c0) kern_x9 (bvand kern_x9 (bvsub kern_x9 c1)))))
(declare-fun kern_x11 () (_ BitVec 64))
(assert (= kern_x11 (ite (= kern_x10 c0) kern_x10 (bvand kern_x10 (bvsub kern_x10 c1)))))
(declare-fun kern_x12 () (_ BitVec 64))
(assert (= kern_x12 (ite (= kern_x11 c0) kern_x11 (bvand kern_x11 (bvsub kern_x11 c1)))))
(declare-fun kern_x13 () (_ BitVec 64))
(assert (= kern_x13 (ite (= kern_x12 c0) kern_x12 (bvand kern_x12 (bvsub kern_x12 c1)))))
(declare-fun kern_x14 () (_ BitVec 64))
(assert (= kern_x14 (ite (= kern_x13 c0) kern_x13 (bvand kern_x13 (bvsub kern_x13 c1)))))
(declare-fun kern_x15 () (_ BitVec 64))
(assert (= kern_x15 (ite (= kern_x14 c0) kern_x14 (bvand kern_x14 (bvsub kern_x14 c1)))))
(declare-fun kern_x16 () (_ BitVec 64))
(assert (= kern_x16 (ite (= kern_x15 c0) kern_x15 (bvand kern_x15 (bvsub kern_x15 c1)))))
(declare-fun kern_x17 () (_ BitVec 64))
(assert (= kern_x17 (ite (= kern_x16 c0) kern_x16 (bvand kern_x16 (bvsub kern_x16 c1)))))
(declare-fun kern_x18 () (_ BitVec 64))
(assert (= kern_x18 (ite (= kern_x17 c0) kern_x17 (bvand kern_x17 (bvsub kern_x17 c1)))))
(declare-fun kern_x19 () (_ BitVec 64))
(assert (= kern_x19 (ite (= kern_x18 c0) kern_x18 (bvand kern_x18 (bvsub kern_x18 c1)))))
(declare-fun kern_x20 () (_ BitVec 64))
(assert (= kern_x20 (ite (= kern_x19 c0) kern_x19 (bvand kern_x19 (bvsub kern_x19 c1)))))
(declare-fun kern_x21 () (_ BitVec 64))
(assert (= kern_x21 (ite (= kern_x20 c0) kern_x20 (bvand kern_x20 (bvsub kern_x20 c1)))))
(declare-fun kern_x22 () (_ BitVec 64))
(assert (= kern_x22 (ite (= kern_x21 c0) kern_x21 (bvand kern_x21 (bvsub kern_x21 c1)))))
(declare-fun kern_x23 () (_ BitVec 64))
(assert (= kern_x23 (ite (= kern_x22 c0) kern_x22 (bvand kern_x22 (bvsub kern_x22 c1)))))
(declare-fun kern_x24 () (_ BitVec 64))
(assert (= kern_x24 (ite (= kern_x23 c0) kern_x23 (bvand kern_x23 (bvsub kern_x23 c1)))))
(declare-fun kern_x25 () (_ BitVec 64))
(assert (= kern_x25 (ite (= kern_x24 c0) kern_x24 (bvand kern_x24 (bvsub kern_x24 c1)))))
(declare-fun kern_x26 () (_ BitVec 64))
(assert (= kern_x26 (ite (= kern_x25 c0) kern_x25 (bvand kern_x25 (bvsub kern_x25 c1)))))
(declare-fun kern_x27 () (_ BitVec 64))
(assert (= kern_x27 (ite (= kern_x26 c0) kern_x26 (bvand kern_x26 (bvsub kern_x26 c1)))))
(declare-fun kern_x28 () (_ BitVec 64))
(assert (= kern_x28 (ite (= kern_x27 c0) kern_x27 (bvand kern_x27 (bvsub kern_x27 c1)))))
(declare-fun kern_x29 () (_ BitVec 64))
(assert (= kern_x29 (ite (= kern_x28 c0) kern_x28 (bvand kern_x28 (bvsub kern_x28 c1)))))
(declare-fun kern_x30 () (_ BitVec 64))
(assert (= kern_x30 (ite (= kern_x29 c0) kern_x29 (bvand kern_x29 (bvsub kern_x29 c1)))))
(declare-fun kern_x31 () (_ BitVec 64))
(assert (= kern_x31 (ite (= kern_x30 c0) kern_x30 (bvand kern_x30 (bvsub kern_x30 c1)))))
(declare-fun kern_x32 () (_ BitVec 64))
(assert (= kern_x32 (ite (= kern_x31 c0) kern_x31 (bvand kern_x31 (bvsub kern_x31 c1)))))
(declare-fun kern_x33 () (_ BitVec 64))
(assert (= kern_x33 (ite (= kern_x32 c0) kern_x32 (bvand kern_x32 (bvsub kern_x32 c1)))))
(declare-fun kern_x34 () (_ BitVec 64))
(assert (= kern_x34 (ite (= kern_x33 c0) kern_x33 (bvand kern_x33 (bvsub kern_x33 c1)))))
(declare-fun kern_x35 () (_ BitVec 64))
(assert (= kern_x35 (ite (= kern_x34 c0) kern_x34 (bvand kern_x34 (bvsub kern_x34 c1)))))
(declare-fun kern_x36 () (_ BitVec 64))
(assert (= kern_x36 (ite (= kern_x35 c0) kern_x35 (bvand kern_x35 (bvsub kern_x35 c1)))))
(declare-fun kern_x37 () (_ BitVec 64))
(assert (= kern_x37 (ite (= kern_x36 c0) kern_x36 (bvand kern_x36 (bvsub kern_x36 c1)))))
(declare-fun kern_x38 () (_ BitVec 64))
(assert (= kern_x38 (ite (= kern_x37 c0) kern_x37 (bvand kern_x37 (bvsub kern_x37 c1)))))
(declare-fun kern_x39 () (_ BitVec 64))
(assert (= kern_x39 (ite (= kern_x38 c0) kern_x38 (bvand kern_x38 (bvsub kern_x38 c1)))))
(declare-fun kern_x40 () (_ BitVec 64))
(assert (= kern_x40 (ite (= kern_x39 c0) kern_x39 (bvand kern_x39 (bvsub kern_x39 c1)))))
(declare-fun kern_x41 () (_ BitVec 64))
(assert (= kern_x41 (ite (= kern_x40 c0) kern_x40 (bvand kern_x40 (bvsub kern_x40 c1)))))
(declare-fun kern_x42 () (_ BitVec 64))
(assert (= kern_x42 (ite (= kern_x41 c0) kern_x41 (bvand kern_x41 (bvsub kern_x41 c1)))))
(declare-fun kern_x43 () (_ BitVec 64))
(assert (= kern_x43 (ite (= kern_x42 c0) kern_x42 (bvand kern_x42 (bvsub kern_x42 c1)))))
(declare-fun kern_x44 () (_ BitVec 64))
(assert (= kern_x44 (ite (= kern_x43 c0) kern_x43 (bvand kern_x43 (bvsub kern_x43 c1)))))
(declare-fun kern_x45 () (_ BitVec 64))
(assert (= kern_x45 (ite (= kern_x44 c0) kern_x44 (bvand kern_x44 (bvsub kern_x44 c1)))))
(declare-fun kern_x46 () (_ BitVec 64))
(assert (= kern_x46 (ite (= kern_x45 c0) kern_x45 (bvand kern_x45 (bvsub kern_x45 c1)))))
(declare-fun kern_x47 () (_ BitVec 64))
(assert (= kern_x47 (ite (= kern_x46 c0) kern_x46 (bvand kern_x46 (bvsub kern_x46 c1)))))
(declare-fun kern_x48 () (_ BitVec 64))
(assert (= kern_x48 (ite (= kern_x47 c0) kern_x47 (bvand kern_x47 (bvsub kern_x47 c1)))))
(declare-fun kern_x49 () (_ BitVec 64))
(assert (= kern_x49 (ite (= kern_x48 c0) kern_x48 (bvand kern_x48 (bvsub kern_x48 c1)))))
(declare-fun kern_x50 () (_ BitVec 64))
(assert (= kern_x50 (ite (= kern_x49 c0) kern_x49 (bvand kern_x49 (bvsub kern_x49 c1)))))
(declare-fun kern_x51 () (_ BitVec 64))
(assert (= kern_x51 (ite (= kern_x50 c0) kern_x50 (bvand kern_x50 (bvsub kern_x50 c1)))))
(declare-fun kern_x52 () (_ BitVec 64))
(assert (= kern_x52 (ite (= kern_x51 c0) kern_x51 (bvand kern_x51 (bvsub kern_x51 c1)))))
(declare-fun kern_x53 () (_ BitVec 64))
(assert (= kern_x53 (ite (= kern_x52 c0) kern_x52 (bvand kern_x52 (bvsub kern_x52 c1)))))
(declare-fun kern_x54 () (_ BitVec 64))
(assert (= kern_x54 (ite (= kern_x53 c0) kern_x53 (bvand kern_x53 (bvsub kern_x53 c1)))))
(declare-fun kern_x55 () (_ BitVec 64))
(assert (= kern_x55 (ite (= kern_x54 c0) kern_x54 (bvand kern_x54 (bvsub kern_x54 c1)))))
(declare-fun kern_x56 () (_ BitVec 64))
(assert (= kern_x56 (ite (= kern_x55 c0) kern_x55 (bvand kern_x55 (bvsub kern_x55 c1)))))
(declare-fun kern_x57 () (_ BitVec 64))
(assert (= kern_x57 (ite (= kern_x56 c0) kern_x56 (bvand kern_x56 (bvsub kern_x56 c1)))))
(declare-fun kern_x58 () (_ BitVec 64))
(assert (= kern_x58 (ite (= kern_x57 c0) kern_x57 (bvand kern_x57 (bvsub kern_x57 c1)))))
(declare-fun kern_x59 () (_ BitVec 64))
(assert (= kern_x59 (ite (= kern_x58 c0) kern_x58 (bvand kern_x58 (bvsub kern_x58 c1)))))
(declare-fun kern_x60 () (_ BitVec 64))
(assert (= kern_x60 (ite (= kern_x59 c0) kern_x59 (bvand kern_x59 (bvsub kern_x59 c1)))))
(declare-fun kern_x61 () (_ BitVec 64))
(assert (= kern_x61 (ite (= kern_x60 c0) kern_x60 (bvand kern_x60 (bvsub kern_x60 c1)))))
(declare-fun kern_x62 () (_ BitVec 64))
(assert (= kern_x62 (ite (= kern_x61 c0) kern_x61 (bvand kern_x61 (bvsub kern_x61 c1)))))
(declare-fun kern_x63 () (_ BitVec 64))
(assert (= kern_x63 (ite (= kern_x62 c0) kern_x62 (bvand kern_x62 (bvsub kern_x62 c1)))))
(declare-fun kern_x64 () (_ BitVec 64))
(assert (= kern_x64 (ite (= kern_x63 c0) kern_x63 (bvand kern_x63 (bvsub kern_x63 c1)))))

; be sure x==0 upon the function exit...
;(assert (not (= kern_x64 c0)))

(declare-fun kern_out () (_ BitVec 64))

; add 1 to kern_out each time if kern_xX!=0:
(assert (= kern_out (bvadd
    (ite (= kern_x0 c0) c0 c1) (ite (= kern_x1 c0) c0 c1) (ite (= kern_x2 c0) c0 c1) (ite (= kern_x3 c0) c0 c1)
    (ite (= kern_x4 c0) c0 c1) (ite (= kern_x5 c0) c0 c1) (ite (= kern_x6 c0) c0 c1) (ite (= kern_x7 c0) c0 c1)
    (ite (= kern_x8 c0) c0 c1) (ite (= kern_x9 c0) c0 c1) (ite (= kern_x10 c0) c0 c1) (ite (= kern_x11 c0) c0 c1)
    (ite (= kern_x12 c0) c0 c1) (ite (= kern_x13 c0) c0 c1) (ite (= kern_x14 c0) c0 c1) (ite (= kern_x15 c0) c0 c1)
    (ite (= kern_x16 c0) c0 c1) (ite (= kern_x17 c0) c0 c1) (ite (= kern_x18 c0) c0 c1) (ite (= kern_x19 c0) c0 c1)
    (ite (= kern_x20 c0) c0 c1) (ite (= kern_x21 c0) c0 c1) (ite (= kern_x22 c0) c0 c1) (ite (= kern_x23 c0) c0 c1)
    (ite (= kern_x24 c0) c0 c1) (ite (= kern_x25 c0) c0 c1) (ite (= kern_x26 c0) c0 c1) (ite (= kern_x27 c0) c0 c1)
    (ite (= kern_x28 c0) c0 c1) (ite (= kern_x29 c0) c0 c1) (ite (= kern_x30 c0) c0 c1) (ite (= kern_x31 c0) c0 c1)
    (ite (= kern_x32 c0) c0 c1) (ite (= kern_x33 c0) c0 c1) (ite (= kern_x34 c0) c0 c1) (ite (= kern_x35 c0) c0 c1)
    (ite (= kern_x36 c0) c0 c1) (ite (= kern_x37 c0) c0 c1) (ite (= kern_x38 c0) c0 c1) (ite (= kern_x39 c0) c0 c1)
    (ite (= kern_x40 c0) c0 c1) (ite (= kern_x41 c0) c0 c1) (ite (= kern_x42 c0) c0 c1) (ite (= kern_x43 c0) c0 c1)
    (ite (= kern_x44 c0) c0 c1) (ite (= kern_x45 c0) c0 c1) (ite (= kern_x46 c0) c0 c1) (ite (= kern_x47 c0) c0 c1)
    (ite (= kern_x48 c0) c0 c1) (ite (= kern_x49 c0) c0 c1) (ite (= kern_x50 c0) c0 c1) (ite (= kern_x51 c0) c0 c1)
    (ite (= kern_x52 c0) c0 c1) (ite (= kern_x53 c0) c0 c1) (ite (= kern_x54 c0) c0 c1) (ite (= kern_x55 c0) c0 c1)
    (ite (= kern_x56 c0) c0 c1) (ite (= kern_x57 c0) c0 c1) (ite (= kern_x58 c0) c0 c1) (ite (= kern_x59 c0) c0 c1)
    (ite (= kern_x60 c0) c0 c1) (ite (= kern_x61 c0) c0 c1) (ite (= kern_x62 c0) c0 c1) (ite (= kern_x63 c0) c0 c1)
)))

(assert (= naive_x kern_x0)) (assert (not (= naive_out kern_out)))

(check-sat)
;(get-model)
