#!/usr/bin/env python3

class Expr:
    def __init__(self,s):
        self.s=s

    def convert_to_Expr_if_int(self, n):
        if isinstance(n, int):
            return Expr(str(n))
        if isinstance(n, Expr):
            return n
        raise AssertionError # unsupported type

    def __str__(self):
        return self.s

    def __truediv__(self, other):
        return Expr("(" + self.s + "/" + self.convert_to_Expr_if_int(other).s + ")")

    def __mod__(self, other):
        return Expr("(" + self.s + "%" + self.convert_to_Expr_if_int(other).s + ")")

    def __add__(self, other):
        return Expr("(" + self.s + "+" + self.convert_to_Expr_if_int(other).s + ")")

    def __eq__(self, other):
        return Expr("(" + self.s + "==" + self.convert_to_Expr_if_int(other).s + ")")

    def __ge__(self, other):
        return Expr("(" + self.s + ">=" + self.convert_to_Expr_if_int(other).s + ")")

    def __le__(self, other):
        return Expr("(" + self.s + "<=" + self.convert_to_Expr_if_int(other).s + ")")

input=Expr("input")
SECS_DAY=24*60*60
dayno = input / SECS_DAY
wday = (dayno + 4) % 7
cond1=(wday==5)
print ("cond1:", cond1)

# also check hour
seconds_within_day=input % SECS_DAY
hour=seconds_within_day / 3600
cond2=hour>=18
cond3=hour<=23
print ("cond2:", cond2)
print ("cond3:", cond3)

