#lang racket
(require json)

(define cmd (current-command-line-arguments))

(when (= (vector-length cmd) 0)
  (displayln "usage: fname.json")
  (exit))

(define fname (vector-ref cmd 0))

; knobs:
(define traverse-strlen-limit 15)
(define strings-limit 500000)

(define a (read-json (open-input-file fname)))
;a
(define accepted-states (hash-ref a 'end))
(define start-state (hash-ref a 'start))
(define statecount (hash-ref a 'statecount))
(define tbl (make-hash))
(for ([x (hash-ref a 'edges)])
  (let [(src (hash-ref x 'src))
        (dst (hash-ref x 'dst))
        (symbol (hash-ref x 'symbol))]
    (hash-update! tbl src
                  (lambda (x) (cons (list dst symbol) x))
                  '())))

;tbl

(define count 0) ; ah! a global variable

(define (traverse-DAG-recursively tbl start cur-string)
  (when (< (string-length cur-string) traverse-strlen-limit)
    (when (member start accepted-states)
      (displayln (string-append "string matched: [" cur-string "]"))
      (set! count (add1 count))
      (when (> count strings-limit)
        (displayln "strings-limit reached, exiting")
        (exit)))
    (when (hash-has-key? tbl start)
      (for/list ([i (hash-ref tbl start)])
        (traverse-DAG-recursively tbl (first i) (string-append cur-string (second i)))))))

(void (traverse-DAG-recursively tbl start-state ""))
(displayln (string-append "total: " (number->string count)))
