
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case '1':
            case '2': state = S1; break;
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S2; break;
            case '3': state = S3; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "1" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S2; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "4" */
            return -1; /* leaf */

        case S3: /* e.g. "3" */
            switch ((unsigned char) *p) {
            case '0':
            case '1': state = S2; break;
            default:  return -1; /* leaf */
            }
            break;

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S1: return 0x1; /* "(1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31)" */
    case S2: return 0x1; /* "(1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31)" */
    case S3: return 0x1; /* "(1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31)" */
    default: return -1; /* unexpected EOT */
    }
}

