#!/usr/bin/env python3
# the code is a bit Lispy, because it was rewritten from Racket...

# JSON files are partially created using my DIY code, to make output files more aesthetically pleasing
# (by default, Python JSON library outputs JSON in one line, or put each element on each line, so
# that the resulting text file is too sparse...)

# this program tries to create a list of dependencies for each package that look like as real data from some Linux distribution.
# each package has a 'core dependencies' which can be randomly changes from version to version.

import json, random, my_utils
from collections import defaultdict

#packages, versions_max, max_deps = 10, 4, 3
#packages, versions_max, max_deps = 50, 5, 5
#packages, versions_max, max_deps = 100, 8, 8
#packages, versions_max, max_deps = 200, 10, 10
#packages, versions_max, max_deps = 500, 7, 8
#packages, versions_max, max_deps = 1000, 6, 6
packages, versions_max, max_deps = 1000, 1, 30

max_conflicting_pairs=packages
#max_conflicting_pairs=packages*2
#max_conflicting_pairs=int(packages/2)

version_low=2000
version_high=2020

def random_versions():
    rt=[random.randint(version_low, version_high) for i in range(versions_max)]
    return sorted(list(set(rt))) # leave unique...

# idx=pkg#
# val=[years]
versions={}

# idx=pkg#
# val=dict
#          idx=version
#          val=list of (package,ver_low,ver_high)
deps=defaultdict(lambda: defaultdict(list))

def gen_package_info1 (pkg):
    versions[pkg]=random_versions()

def gen_dep_for_package_version (pkg, version, dep_pkg):
    dep_ver_low=min(versions[pkg])
    dep_ver_high=max(versions[pkg])
    # version must be in [dep_ver_low, dep_ver_high]
    if version<dep_ver_low:
        return
    if version>dep_ver_high:
        return

    # 0000 - 9999
    # 0000 - pkg_cur_ver
    # pkg_cur_ver-q - 9999
    # a single version: pkg_cur_ver

    while True:
        q=random.randint(0, version - dep_ver_low)

        c=random.randint(0, 3)
        if c==0:
            ver_req_low, ver_req_high = 0000, 9999
        elif c==1:
            ver_req_low, ver_req_high = 0000, version
        elif c==2:
            ver_req_low, ver_req_high = version-q, 9999
        elif c==3:
            ver_req_low, ver_req_high = version, version

        # at least one versions[i] must be between [ver_req_low...ver_req_high]
        if my_utils.element_in_array_is_in_range (versions[dep_pkg], ver_req_low, ver_req_high):
            break
        # otherwise, throw our dice again

    deps[pkg][version].append((dep_pkg, ver_req_low, ver_req_high))

all_deps={}

def gen_deps_for_package_version (pkg, version, core_deps):
    global all_deps
    deps_t=core_deps

    if pkg>0:
        # add 0..1 packages randomly
        if random.random()<0.1:
            deps_t.add(random.randint(0, pkg-1))
        #if random.random()<0.1:
        #    deps_t.add(random.randint(0, pkg-1))

    all_deps[pkg]=all_deps[pkg] | deps_t

    # remove 0..1 packages randomly
    if len(deps_t)>0 and random.random()<0.1:
        deps_t.remove(random.choice(list(deps_t)))
    #if len(deps_t)>0 and random.random()<0.1:
    #    deps_t.remove(random.choice(list(deps_t)))

    [gen_dep_for_package_version (pkg, version, dep) for dep in deps_t]

    return "    \""+str(version)+"\" : " + json.dumps(sorted(deps[pkg][version]), sort_keys=True)

def gen_package_info2 (f, pkg, last2):
    global all_deps
    all_deps[pkg]=set()
    f.write ("\""+str(pkg)+"\":\n")
    f.write ("{\n")
    # gen core deps
    core_deps=set()
    if pkg>0:
        [core_deps.add(random.randint(0, pkg-1)) for i in range(random.randint(0, max_deps))]
    t=[]
    for version in versions[pkg]:
        s=gen_deps_for_package_version (pkg, version, core_deps)
        if s!=None:
            t.append(s)

    [f.write (a+ [",", ""][a==t[-1]] +"\n") for a in t]

    f.write ("}" + [",",""][last2] + "\n")

f=open("deps.json", "w")
f.write ("{\n")
[gen_package_info1 (p) for p in range(packages)]
[gen_package_info2 (f, p, p==packages-1) for p in range(packages)]
f.write ("}\n")

f=open("vers.json", "w")
f.write ("{\n")
for v in versions:
    s="\t\"" + str(v) + "\" : " + json.dumps(versions[v])
    f.write (s + [ ",",""][v==max(versions)] + "\n") # address array using bool
f.write ("}\n")

# gen conflicts

conflicts={}

for c in range(max_conflicting_pairs):
    while True:
        p1=random.randint(1, packages-1)
        p2=random.randint(1, packages-1)
        if (p1 not in all_deps[p2]) and (p2 not in all_deps[p1]) and ((p1,p2) not in conflicts):
            p1_v1=random.choice(versions[p1])
            p1_v2=random.choice(versions[p1])
            p1_ver_low=min(p1_v1, p1_v2)
            p1_ver_high=max(p1_v1, p1_v2)
            p2_v1=random.choice(versions[p2])
            p2_v2=random.choice(versions[p2])
            p2_ver_low=min(p2_v1, p2_v2)
            p2_ver_high=max(p2_v1, p2_v2)
            conflicts[((p1, p1_ver_low, p1_ver_high), (p2, p2_ver_low, p2_ver_high))]=True
            break

f=open("conflicts.json", "w")
f.write ("[\n")
for c, i in zip(conflicts, range(len(conflicts))):
    s=json.dumps(c)
    f.write (s+ [",",""][i==len(conflicts)-1]  +"\n")
f.write ("]\n")
