#!/usr/bin/env bash

TMP=$(mktemp)

# skip hidden files
find . -name '*' -not -path '*/\.*' -type f -print0 | while read -d $'\0' file
do
        # take the date of a newest commit:
        git_response=$(git log -1 --format=%cd --date=iso-local "$file")
        # if git's response isn't empty...
        if [ ! -z "$git_response" ];
        then
                echo $git_response "|" "$file" >> $TMP
        fi
done

cat $TMP | sort

