#include <stdint.h>
#include <stdbool.h>
#include <assert.h>

// CRC-64-ECMA in https://en.wikipedia.org/wiki/Cyclic_redundancy_check
uint64_t crc64(uint64_t crc, unsigned char *buf, int len)
{
    int k;

    crc = ~crc;
    while (len--)
    {
        crc ^= *buf++;
        for (k = 0; k < 8; k++)
            crc = crc & 1 ? (crc >> 1) ^ 0xC96C5795D7870F42 : crc >> 1;
    }
    return ~crc;
}

#define SIZE 16 // 40 minutes, 0..9a..f

int valid_char(char c)
{
        if (c>='0' && c<='9')
                return 1;
        if (c>='a' && c<='f')
                return 1;
        return 0;
};

void main()
{
        char str[SIZE];

        int i=0;
        for (i=0; i<SIZE; i++)
        {
                if (valid_char(str[i])==0)
                        return;
        };

    if (crc64(0, &str[0], SIZE)==0)
                assert (0);
};

