
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case '0': break;
            case '1': state = S1; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "1" */
            switch ((unsigned char) *p) {
            case '1': state = S0; break;
            case '0': state = S2; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "10" */
            switch ((unsigned char) *p) {
            case '0': state = S1; break;
            case '1': break;
            default:  return -1; /* leaf */
            }
            break;

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S0: return 0x1; /* "(0|(1(01*0)*1))*" */
    default: return -1; /* unexpected EOT */
    }
}

