
int
fsm_main(const char *s)
{
    const char *p;

    enum {
        S0, S1, S2, S3, S4, S5, S6, S7, S8, S9,
        S10, S11, S12, S13, S14, S15, S16, S17, S18, S19,
        S20, S21, S22, S23, S24, S25, S26, S27, S28
    } state;

    state = S0;

    for (p = s; *p != '\0'; p++) {
        switch (state) {
        case S0: /* start */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3': state = S1; break;
            default:  return -1; /* leaf */
            }
            break;

        case S1: /* e.g. "0" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S2; break;
            default:  return -1; /* leaf */
            }
            break;

        case S2: /* e.g. "00" */
            switch ((unsigned char) *p) {
            case '-': state = S3; break;
            default:  return -1; /* leaf */
            }
            break;

        case S3: /* e.g. "00-" */
            switch ((unsigned char) *p) {
            case 'J': state = S4; break;
            case 'F': state = S5; break;
            case 'A': state = S6; break;
            case 'O': state = S7; break;
            case 'S': state = S8; break;
            case 'N': state = S9; break;
            case 'D': state = S10; break;
            case 'M': state = S11; break;
            default:  return -1; /* leaf */
            }
            break;

        case S4: /* e.g. "00-J" */
            switch ((unsigned char) *p) {
            case 'u': state = S27; break;
            case 'a': state = S28; break;
            default:  return -1; /* leaf */
            }
            break;

        case S5: /* e.g. "00-F" */
            switch ((unsigned char) *p) {
            case 'e': state = S26; break;
            default:  return -1; /* leaf */
            }
            break;

        case S6: /* e.g. "00-A" */
            switch ((unsigned char) *p) {
            case 'p': state = S24; break;
            case 'u': state = S25; break;
            default:  return -1; /* leaf */
            }
            break;

        case S7: /* e.g. "00-O" */
            switch ((unsigned char) *p) {
            case 'c': state = S23; break;
            default:  return -1; /* leaf */
            }
            break;

        case S8: /* e.g. "00-S" */
            switch ((unsigned char) *p) {
            case 'e': state = S22; break;
            default:  return -1; /* leaf */
            }
            break;

        case S9: /* e.g. "00-N" */
            switch ((unsigned char) *p) {
            case 'o': state = S21; break;
            default:  return -1; /* leaf */
            }
            break;

        case S10: /* e.g. "00-D" */
            switch ((unsigned char) *p) {
            case 'e': state = S20; break;
            default:  return -1; /* leaf */
            }
            break;

        case S11: /* e.g. "00-M" */
            switch ((unsigned char) *p) {
            case 'a': state = S12; break;
            default:  return -1; /* leaf */
            }
            break;

        case S12: /* e.g. "00-Ma" */
            switch ((unsigned char) *p) {
            case 'r':
            case 'y': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S13: /* e.g. "00-Dec" */
            switch ((unsigned char) *p) {
            case '-': state = S14; break;
            default:  return -1; /* leaf */
            }
            break;

        case S14: /* e.g. "00-Dec-" */
            switch ((unsigned char) *p) {
            case '1': state = S15; break;
            case '2': state = S16; break;
            default:  return -1; /* leaf */
            }
            break;

        case S15: /* e.g. "00-Dec-1" */
            switch ((unsigned char) *p) {
            case '9': state = S17; break;
            default:  return -1; /* leaf */
            }
            break;

        case S16: /* e.g. "00-Dec-2" */
            switch ((unsigned char) *p) {
            case '0': state = S17; break;
            default:  return -1; /* leaf */
            }
            break;

        case S17: /* e.g. "00-Dec-20" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S18; break;
            default:  return -1; /* leaf */
            }
            break;

        case S18: /* e.g. "00-Dec-200" */
            switch ((unsigned char) *p) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9': state = S19; break;
            default:  return -1; /* leaf */
            }
            break;

        case S19: /* e.g. "00-Dec-2000" */
            return -1; /* leaf */

        case S20: /* e.g. "00-De" */
            switch ((unsigned char) *p) {
            case 'c': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S21: /* e.g. "00-No" */
            switch ((unsigned char) *p) {
            case 'v': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S22: /* e.g. "00-Se" */
            switch ((unsigned char) *p) {
            case 'p': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S23: /* e.g. "00-Oc" */
            switch ((unsigned char) *p) {
            case 't': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S24: /* e.g. "00-Ap" */
            switch ((unsigned char) *p) {
            case 'r': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S25: /* e.g. "00-Au" */
            switch ((unsigned char) *p) {
            case 'g': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S26: /* e.g. "00-Fe" */
            switch ((unsigned char) *p) {
            case 'b': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S27: /* e.g. "00-Ju" */
            switch ((unsigned char) *p) {
            case 'l':
            case 'n': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        case S28: /* e.g. "00-Ja" */
            switch ((unsigned char) *p) {
            case 'n': state = S13; break;
            default:  return -1; /* leaf */
            }
            break;

        default:
            ; /* unreached */
        }
    }

    /* end states */
    switch (state) {
    case S19: return 0x1; /* "[0123][0-9]-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-(19|20)[0-9]{2}" */
    default: return -1; /* unexpected EOT */
    }
}

